<!DOCTYPE html>
<html lang="en" class="dark">

<meta http-equiv="content-type" content="text/html;charset=UTF-8" />
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta property="og:image" content="{{ asset('storage/app/public/' . $settings->logo) }}">

    <title>{{$title}}-{{$settings->site_name}}</title>
    <link rel="apple-touch-icon" sizes="180x180" href="{{ asset('storage/app/public/'.$settings->favicon)}}">
<link rel="icon" type="image/png" sizes="32x32" href="{{ asset('storage/app/public/'.$settings->favicon)}}">
<link rel="icon" type="image/png" sizes="16x16" href="{{ asset('storage/app/public/'.$settings->favicon)}}">
<link rel="manifest" href="{{ asset('storage/app/public/'.$settings->favicon)}}">
<meta name="msapplication-TileColor" content="#da532c">
<meta name="theme-color" content="#ffffff">
    <link rel="preconnect" href="https://fonts.googleapis.com/">
    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Montserrat:wght@100;200;300;400;500;600;700;800;900&amp;family=Nunito+Sans:wght@400;500;600;700;800;900&amp;display=swap"
        rel="stylesheet">

    <meta property="og:url" content=""/>
    <meta property="og:type" content="website"/>
    <meta property="og:title"
          content="{{$settings->site_name}} -{{$title}}"/>
    <meta property="og:description"
          content="Decentralised Real Estate Market Investment"/>
    <meta property="og:image" content="banners/share.png"/>
    <meta name="twitter:title" content="{{$settings->site_name}}">
    <meta name="twitter:description" content="Decentralised Real Estate Market Investment">
    <meta name="twitter:image:src" content="banners/share.png">
    <meta name="twitter:card" content="summary_large_image"/>

    <!-- Scripts -->
    <link rel="preload" as="style" href="temp/front/build/assets/app-c7bca331.css" />
    <link rel="modulepreload" href="temp/front/build/assets/app-dbd2922c.js" />
    <link rel="stylesheet" href="temp/front/build/assets/app-c7bca331.css" />
    <script type="module" src="temp/front/build/assets/app-dbd2922c.js"></script></head>
<body class="relative text-white antialiased min-h-screen overflow-x-hidden bg-gradient-radial from-[#313031] to-[#1D1D1D]" x-data="{mobileMenuOpen: false}">
<div class="grid items-center pt-0">
    <section
    style="background: url('temp/front/assets/img/front/front-top-bg.jpg'); background-size: cover; background-position: center;">
    <div class="px-3 mb-6 lg:mb-12 w-full lg:max-w-7xl mx-auto flex flex-col justify-center items-center">
        <div class="flex justify-between items-center w-full py-6">
    <a href="/">
        <img src="{{ asset('storage/app/public/' . $settings->logo) }} " class="h-12"/>
    </a>
    <button class="inline-flex md:hidden" x-on:click="mobileMenuOpen = !mobileMenuOpen">
        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2"
             stroke="currentColor" class="w-8 h-8">
            <path stroke-linecap="round" stroke-linejoin="round"
                  d="M3.75 5.25h16.5m-16.5 4.5h16.5m-16.5 4.5h16.5m-16.5 4.5h16.5"/>
        </svg>
    </button>
    <ul class="hidden lg:flex gap-4 uppercase text-sm font-semibold">
        <li><a href="/"
               class="hover:underline hover:text-gold  underline text-gold ">Home</a>
        </li>
        <li><a href="cubeland" class="hover:underline hover:text-gold ">CubeLand™</a></li>
       
       
        <li><a href="faq"
               class="hover:underline hover:text-gold ">FAQ</a>
        </li>
        <!-- <li><a href="https://t.me/{{$settings->site_name}}_ai" target="_blank"
               class="hover:underline hover:text-gold">Contact us</a></li> -->
    </ul>
</div>
<div
    class="fixed hidden top-0 left-0 bottom-0 right-0 bg-gradient-radial from-[#313031] to-[#1D1D1D] h-full pl-3 z-50 md:z-0 overflow-x-auto"
    :class="{'!block': mobileMenuOpen}">
    <div class="block md:hidden pt-4">
        <div class="flex justify-end">
            <button x-on:click="mobileMenuOpen = !mobileMenuOpen">
                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                     stroke="currentColor" class="w-6 h-6 mr-3">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"/>
                </svg>
            </button>
        </div>
        <ul class="flex flex-col gap-3 mt-3">
            <li>
                <a href="/"
                   class="uppercase border-2 border-gold bg-gradient-to-r to-[#232323] hover:to-gold hover:from-gold text-white inline-flex h-12 items-center text-center justify-center rounded-sm font-semibold w-full">
                    <span style="text-shadow: 0px 0px 8px rgba(0,0,0,0.5)">Home</span></a>
            </li>
            <li>
                <a href="cubeland"
                   class="uppercase border-2 border-gold bg-gradient-to-r to-[#232323] hover:to-gold hover:from-gold text-white inline-flex h-12 items-center text-center justify-center rounded-sm font-semibold w-full">
                    <span style="text-shadow: 0px 0px 8px rgba(0,0,0,0.5)">CubeLand™</span></a>
            </li>
           
            <li>
                <a href="faq"
                   class="uppercase border-2 border-gold bg-gradient-to-r to-[#232323] hover:to-gold hover:from-gold text-white inline-flex h-12 items-center text-center justify-center rounded-sm font-semibold w-full">
                    <span style="text-shadow: 0px 0px 8px rgba(0,0,0,0.5)">FAQ</span></a>
            </li>
            <!-- <li>
                <a href="https://t.me/{{$settings->site_name}}_ai" target="_blank"
                   class="uppercase border-2 border-gold bg-gradient-to-r to-[#232323] hover:to-gold hover:from-gold text-white inline-flex h-12 items-center text-center justify-center rounded-sm font-semibold w-full">
                    <span style="text-shadow: 0px 0px 8px rgba(0,0,0,0.5)">Contact us</span></a>
            </li> -->
                            <li class="mt-6">
                    <a href="login"
                       class="uppercase border-2 border-[#80CBD0] bg-gradient-to-r to-[#232323] hover:to-[#80CBD0] hover:from-[#80CBD0] text-white inline-flex h-12 items-center text-center justify-center rounded-sm font-semibold w-full">
                        <span style="text-shadow: 0px 0px 8px rgba(0,0,0,0.5)">Log in</span></a>
                </li>
                <li>
                    <a href="register"
                       class="uppercase border-2 border-gold bg-gradient-to-r to-[#232323] hover:to-gold hover:from-gold text-white inline-flex h-12 items-center text-center justify-center rounded-sm font-semibold w-full">
                        <span style="text-shadow: 0px 0px 8px rgba(0,0,0,0.5)">Open Account</span></a>
                </li>
                    </ul>
    </div>
</div>

@yield('content')


<div class="py-3 primary-gradient border-t-[1px] border-primary">
    <div class="mb-6 lg:mb-12 w-full lg:max-w-7xl mx-auto flex flex-col px-3 md:px-6 py-4">
        <div class="grid grid-cols-2 md:grid-cols-5 w-full gap-x-3 gap-y-6">
            <ul class="flex flex-col gap-3 ">
                <li class="font-bold">{{$settings->site_name}}</li>
                <li>
                    <a href="/" class="hover:underline">Home</a>
                </li>
                <li>
                    <a href="register" class="hover:underline">Open account</a>
                </li>
                <li>
                    <a href="login" class="hover:underline">Sign In</a>
                </li>
                <li>
                    <a href="login" class="hover:underline">How to start</a>
                </li>
            </ul>
            <ul class="flex flex-col gap-3">
                <li class="font-bold">About us</li>
                <li>
                    <a href="/" class="hover:underline">Company</a>
                </li>
                <li>
                    <a href="cubeland" class="hover:underline">CubeLand™</a>
                </li>
                <li>
                    <a href="faq" class="hover:underline">FAQ</a>
                </li>
            </ul>
            <ul class="flex flex-col gap-3">
                <li class="font-bold">Solutions</li>
                <li>
                    <a href="login" class="hover:underline">Earn more</a>
                </li>
                
                
            </ul>
            <ul class="flex flex-col gap-3">
                <li class="font-bold">Documentation</li>
                
                <li>
                    <a href="privacy" class="hover:underline">Privacy Policy</a>
                </li>
                <li>
                    <a href="terms" class="hover:underline">Terms</a>
                </li>
            </ul>
            
        </div>
        <div class="mt-6 flex flex-col md:flex-row justify-between gap-3">
            <div class="flex flex-row gap-2 items-center">
                <p class="text-sm">ACCEPTED<br>PROCESSORS:</p>
                <div class="flex flex-row gap-2">
                                            <img src="temp/front/assets/img/crypto/btc.svg" class="h-6 md:h-8"/>
                                            <img src="temp/front/assets/img/crypto/ltc.svg" class="h-6 md:h-8"/>
                                            <img src="temp/front/assets/img/crypto/trx.svg" class="h-6 md:h-8"/>
                                            <img src="temp/front/assets/img/crypto/usdt-trc20.svg" class="h-6 md:h-8"/>
                                            <img src="temp/front/assets/img/crypto/usdt-bep20.svg" class="h-6 md:h-8"/>
                                            <img src="temp/front/assets/img/crypto/bnb.svg" class="h-6 md:h-8"/>
                                    </div>
            </div>
            <div class="flex flex-row gap-2 items-center">
                <p class="text-sm">COMING<br>SOON:</p>
                <div class="flex flex-row gap-2">
                    <img src="temp/front/assets/img/front/app-store.png" class="h-10" />
                    <img src="temp/front/assets/img/front/google-play.png" class="h-10" />
                </div>
            </div>
            <div class="text-sm flex items-center">
                Copyright 2021-2023 {{ $settings->site_name }}, All rights reserved.
            </div>
        </div>
    </div>
    <div id="hmetrics_site_verification" style="display: none;">173183</div>
</div>
</div>
<div class="fixed flex flex-col gap-3 bottom-8 right-3 items-end">
    <!--<a href="https://t.me/{{$settings->site_name}}_support" target="_blank"-->
    <!--   class="relative h-16 bg-transparent flex flex-row items-center group hover:scale-105">-->
    <!--    <img src="temp/front/assets/img/front/telegram-dark-icon.svg" class="h-full"/>-->
    <!--</a>-->
    
</div>
<script data-cfasync="false" src="https://cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script></body>

@if($settings->whatsapp)
<script type="text/javascript">
    (function () {
        var options = {
            whatsapp: "{{$settings->whatsapp}}", // WhatsApp number
            call_to_action: "Message us", // Call to action
            position: "left", // Position may be 'right' or 'left'
            pre_filled_message: "Hello I am", // WhatsApp pre-filled message
        };
        var proto = document.location.protocol, host = "getbutton.io", url = proto + "//static." + host;
        var s = document.createElement('script'); s.type = 'text/javascript'; s.async = true; s.src = url + '/widget-send-button/js/init.js';
        s.onload = function () { WhWidgetSendButton.init(host, proto, options); };
        var x = document.getElementsByTagName('script')[0]; x.parentNode.insertBefore(s, x);
    })();
</script>
@endif
@if($settings->tido)
<script src="//code.tidio.co/{{$settings->tido}}" async></script>
@endif
</html>
